package {
	
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Mesh;
	import away3d.events.LoaderEvent;
	import away3d.lights.DirectionalLight3D;
	import away3d.loaders.Collada;
	import away3d.loaders.Object3DLoader;
	import away3d.materials.WhiteShadingBitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Cube;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	
	import fl.motion.easing.Cubic;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class MaxLogoDemo extends EventDispatcherThread implements IDemoThread {
		
		[Embed(source='../bin-debug/models/max.png')]
		private static const maxTexClass:Class;
		private static const maxTex:BitmapData = Bitmap(new maxTexClass()).bitmapData;
		
		private var _ctx:Context;
		private var _max:Object3DLoader;
		private var _anime:TweensyTimeline;
		private var _monitor:Monitor;
		
		public function MaxLogoDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			var mat:WhiteShadingBitmapMaterial = new WhiteShadingBitmapMaterial(maxTex);
			this._max = Collada.load('models/max.dae', {material:mat});
			this._max.scale(0.1);
			this._ctx.arview.marker.addChild(this._max);
			event(this._max, LoaderEvent.LOAD_SUCCESS, this._onLoaded);
		}
		
		private function _onLoaded(e:Event):void {
			var mesh:Mesh = ObjectContainer3D(this._max.handle).children[0];
			this._anime = Tweensy.fromTo(mesh, {rotationY:0}, {rotationY:360}, 2, Cubic.easeInOut, 1);
			this._anime.repeatType = TweensyTimeline.REPLAY;
			this._anime.repeatCount = 0;
			this._monitor = new Monitor();
			this._monitor.wait();
		}
		
		public function close():void {
			if (this._monitor) {
				this._monitor.notifyAll();
				this._anime.stopAll();
				this._anime = null;
			}
		}
		
		protected override function finalize():void {
			this._ctx.arview.marker.removeChild(this._max.handle);
			this._ctx = null;
			this._max = null;
		}
	}
}